/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh mbox ,
     mball;
/******************************************************************************/
void InitPre()
{
   App.name="Viewport";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.full(true);
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=3;

   Material *material=Materials("../data/mtrl/brick/0.mtrl");

   mbox .create(1).B(0).create( Box(4),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create mesh box, reverse it because it's meant to be viewed from inside
   mball.create(1).B(0).create(Ball(1),VTX_TX0|VTX_NRM|VTX_TNG)          ; // create mesh ball

   // set mesh materials, rendering versions and bounding boxes
   mbox .setMaterial(material).setRender().setBox();
   mball.setMaterial(material).setRender().setBox();

   return true;
}
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox .draw();
         mball.draw();
      break;

      case RM_LIGHT:
         LightPoint(25,Vec(0,3,0)).add();
      break;
   }
}
void Draw()
{
   // render to active viewport
   Renderer(Render);

   // render to another viewport
   {
      // set new viewport
      Rect rect(-D.w(),-D.h(),0,0); // setup viewport rectangle to left bottom quarter
           rect.extend(-0.05);      // extend with negative value, to make it smaller
      Viewport.set(rect);           // set viewport with given rectangle

      // render everything once again
      Renderer(Render);

      // restore default viewport by activating ViewportFull
      ViewportFull.set();
   }
}
/******************************************************************************/
